import { CanActivate, ExecutionContext } from '@nestjs/common';
import { Reflector } from '@nestjs/core';
import { UserRole } from '@prisma/client';
export interface AuthenticatedUser {
    id: string;
    email: string;
    tenantId: string | null;
    role: UserRole;
    isActive: boolean;
}
export declare class TenantGuard implements CanActivate {
    private reflector;
    constructor(reflector: Reflector);
    canActivate(context: ExecutionContext): boolean;
}
export declare const REQUIRE_TENANT_KEY = "requireTenant";
export declare const RequireTenant: () => any;
