import { PaymentMethod, SaleStatus } from '@prisma/client';
export declare class SaleItemResponseDto {
    id: string;
    productId: string;
    productName: string;
    productSku: string;
    quantity: number;
    unitPrice: number;
    totalPrice: number;
    createdAt: Date;
}
export declare class SaleResponseDto {
    id: string;
    tenantId: string;
    saleNumber: string;
    customerName?: string;
    customerEmail?: string;
    customerPhone?: string;
    subtotal: number;
    taxAmount: number;
    discountAmount: number;
    total: number;
    paymentMethod: PaymentMethod;
    status: SaleStatus;
    notes?: string;
    processedBy?: string;
    createdAt: Date;
    updatedAt: Date;
    saleItems: SaleItemResponseDto[];
}
export declare class SalesSummaryDto {
    totalSales: number;
    totalRevenue: number;
    averageSaleAmount: number;
    todaySales: number;
    todayRevenue: number;
}
