import { PrismaService } from '../common/prisma/prisma.service';
import { CreateSaleDto } from './dto/create-sale.dto';
import { SaleResponseDto } from './dto/sale-response.dto';
import { AuthenticatedUser } from '../auth/guards/tenant.guard';
import { Sale, SaleItem, SaleStatus } from '@prisma/client';
export interface SaleWithItems extends Sale {
    saleItems: SaleItem[];
}
export declare class SalesService {
    private prisma;
    private readonly logger;
    constructor(prisma: PrismaService);
    createSale(createSaleDto: CreateSaleDto, user: AuthenticatedUser): Promise<SaleResponseDto>;
    private validateTenantAccess;
    private validateSaleItems;
    private fetchAndValidateProducts;
    private calculateSaleTotals;
    private generateSaleNumber;
    private createSaleRecord;
    private createSaleItems;
    private updateInventoryAndCreateAdjustments;
    private formatSaleResponse;
    private handlePrismaError;
    findAll(user: AuthenticatedUser, page?: number, limit?: number, status?: SaleStatus, startDate?: Date, endDate?: Date): Promise<{
        sales: SaleResponseDto[];
        total: number;
    }>;
    findOne(id: string, user: AuthenticatedUser): Promise<SaleResponseDto>;
}
